import { getAuth, toggleMembership } from "./auth.js";

const q = (id) => document.getElementById(id);

async function load() {
  const {
    provider = "openai",
    openaiKey = "",
    model = "gpt-4o-mini",
    wallpaperUrl = "",
    gridCols = 8,
    userEmail = "",
    member = false,
  } = await chrome.storage.sync.get({});
    q("provider").value = provider;
    q("openaiKey").value = openaiKey;
    q("model").value = model;
    q("wallpaperUrl").value = wallpaperUrl;
    q("tileMin").value = tileMin;
    q("tileMinVal").textContent = tileMin;
    q("gap").value = gap;
    q("gapVal").textContent = gap;
    q("email").value = userEmail;
    q("authState").textContent = `会员：${member ? "已开通" : "未开通"}`;
}

async function saveAI() {
  await chrome.storage.sync.set({
    provider: q("provider").value,
    openaiKey: q("openaiKey").value.trim(),
    model: q("model").value.trim(),
  });
  alert("已保存 AI 设置");
}

async function saveAppearance() {
  const cols = Math.max(4, Math.min(12, Number(q("gridCols").value || 8)));
    const tileMin = Math.max(64, Math.min(160, Number(q("tileMin").value || 96)));
    const gap = Math.max(8, Math.min(40, Number(q("gap").value || 20)));
    await chrome.storage.sync.set({ wallpaperUrl: q("wallpaperUrl").value.trim(), tileMin, gap });
  alert("已保存外观");
  }

  q("tileMin").addEventListener("input", (e) => q("tileMinVal").textContent = e.target.value);
  q("gap").addEventListener("input", (e) => q("gapVal").textContent = e.target.value);
}

async function saveEmail() {
  await chrome.storage.sync.set({ userEmail: q("email").value.trim() });
  await load();
}

async function toggleMember() {
  await chrome.storage.sync.set({
    member: !(await chrome.storage.sync.get({ member: false })).member,
  });
  await load();
}

q("saveAI").addEventListener("click", saveAI);
q("saveAppearance").addEventListener("click", saveAppearance);
q("saveEmail").addEventListener("click", saveEmail);
q("toggleMember").addEventListener("click", toggleMember);

load();
