const dlg = document.getElementById("authDialog");
const info = document.getElementById("authInfo");

export async function getAuth() {
  const { userEmail = "", member = false } = await chrome.storage.sync.get({
    userEmail: "",
    member: false,
  });
  return { userEmail, member };
}

export async function signInOrRegister(opts = {}) {
  const { userEmail, member } = await getAuth();
  info.textContent = userEmail
    ? `当前账号：${userEmail} · 会员：${member ? "是" : "否"}`
    : "未登录";
  await showDialog();
}

export async function toggleMembership() {
  const { member } = await getAuth();
  await chrome.storage.sync.set({ member: !member });
}

function showDialog() {
  return new Promise((resolve) => {
    dlg.showModal();
    const onClose = () => {
      dlg.removeEventListener("close", onClose);
      resolve();
    };
    dlg.addEventListener("close", onClose);
  });
}

// Wire buttons inside dialog (works in newtab context)
document.getElementById("btnLogin")?.addEventListener("click", async (e) => {
  e.preventDefault();
  const email = document.getElementById("authEmail").value.trim();
  if (!email) return;
  await chrome.storage.sync.set({ userEmail: email });
  info.textContent = `已登录：${email}`;
});

document.getElementById("btnRegister")?.addEventListener("click", async (e) => {
  e.preventDefault();
  const email = document.getElementById("authEmail").value.trim();
  if (!email) return;
  await chrome.storage.sync.set({ userEmail: email, member: false });
  info.textContent = `注册成功：${email}（未开通会员）`;
});

document
  .getElementById("btnToggleMember")
  ?.addEventListener("click", async (e) => {
    e.preventDefault();
    const { member } = await getAuth();
    await chrome.storage.sync.set({ member: !member });
    info.textContent = `会员状态：${!member ? "已开通" : "已关闭"}`;
  });
