# 图标获取系统 — 测试指南

## ✅ 快速本地测试 (5 分钟)

### 环境准备

1. 在 Chrome DevTools 中加载此扩展（开发者模式）
2. 打开扩展的新标签页（应显示网格 + 侧边栏）
3. 打开浏览器开发者工具（F12）选中 **Console** 或 **Network** 标签

---

## 测试场景 1：字母占位符 → Clearbit 替换

**预期行为**：网格图标初始显示字母，1-3 秒后替换为真实图标

### 步骤

1. 观察网格中的第一个图标（如 ChatGPT）

   - ✓ 应立即显示彩色字母（如"C"或"CH"）
   - ✓ 背景色应与其他 ChatGPT 出现处一致

2. 等待 1-3 秒

   - ✓ 字母应逐步替换为 Clearbit 图标
   - ✓ 如果图标加载成功，字母会被完全覆盖

3. 刷新页面 (F5)

   - ✓ 同一网站的图标应立即出现（从 indexedDB 缓存读取）
   - ✓ **不应再显示字母**，直接显示缓存的图标

4. **检查控制台**
   - ✓ 不应有任何 404 错误
   - ✓ 不应有 favicon 相关的红色错误
   - 可以看到 `console.warn` 的非关键日志（如 CORS 失败），这是正常的

---

## 测试场景 2：侧边栏图标一致性

**预期行为**：侧边栏与网格显示相同的图标

### 步骤

1. 点击左上角的 **☰** 按钮打开侧边栏
2. 观察侧边栏中的书签列表

   - ✓ 每个书签应显示彩色字母占位符
   - ✓ 字母应与该书签在网格中的字母相同

3. 等待 1-3 秒

   - ✓ 字母应被替换为与网格相同的图标

4. 侧边栏拖拽插入测试
   - 从侧边栏选择一个书签（如 GitHub）
   - 长按并拖入网格的某个位置
   - ✓ 应在鼠标位置处插入（而非末尾追加）
   - ✓ 该书签应显示与侧边栏相同的图标（初始为字母，后期为真实图标）

---

## 测试场景 3：编辑对话框图标一致性

**预期行为**：编辑预览与网格/侧边栏图标逻辑相同

### 步骤

1. 点击网格中某个图标的 **✎** (编辑按钮)
2. 编辑对话框打开

   - ✓ 图标预览区应显示该书签的当前图标
   - ✓ 若刚打开，应显示字母占位符（与网格相同）

3. 点击 **🔍 自动获取**

   - ✓ 按钮应变为 **⏳ 获取中...**
   - ✓ 1-3 秒后应获取到图标 URL 并显示在预览区
   - ✓ 若失败，按钮恢复为 **🔍 自动获取**，提示"无法自动获取"

4. 修改名称并点击 **保存**
   - ✓ 网格应立即更新图标和名称
   - ✓ 若重新打开编辑对话，应保存的内容

---

## 测试场景 4：缓存命中验证

**预期行为**：7 天内重复访问同一网站时，图标应秒速加载（来自 indexedDB）

### 步骤

1. 记录首次打开扩展的时间 (T0)
2. 加载网格，观察某些图标的加载速度（可能需要 1-3 秒）
3. 关闭扩展标签页
4. 重新打开扩展标签页

   - ✓ 图标应**瞬间显示**（不再显示字母，直接显示真实图标）
   - 这表示缓存命中成功

5. 验证缓存内容（高级操作）
   ```javascript
   // 在扩展控制台 (DevTools > Console) 运行
   const db = await new Promise((resolve, reject) => {
     const req = indexedDB.open("favicon_cache_db", 1);
     req.onsuccess = () => resolve(req.result);
     req.onerror = () => reject(req.error);
   });
   const tx = db.transaction("icons", "readonly");
   const store = tx.objectStore("icons");
   store.getAll().onsuccess = (e) => {
     console.log("缓存中的域名数量:", e.target.result.length);
     console.log("缓存内容:", e.target.result);
   };
   ```

---

## 测试场景 5：无网络 / 图标失败恢复

**预期行为**：若 Clearbit/HTML 解析失败，应保留字母占位符，不出现空白

### 步骤

1. 打开 DevTools 的 **Network** 标签
2. 右键 Clearbit 或 HTML 解析的请求 → **Block request URL**

   - 模拟 Clearbit 不可用的情况

3. 刷新扩展新标签页

   - ✓ 网格应显示字母占位符
   - ✓ 1-3 秒后仍应保持字母（因为 Clearbit 被阻止了）
   - ✓ **不应显示空白**

4. 移除请求阻止，刷新
   - ✓ 图标应恢复为 Clearbit 或 HTML 解析得到的真实图标

---

## 测试场景 6：自定义图标优先级

**预期行为**：用户上传/设置的图标应最高优先，绕过所有异步流程

### 步骤

1. 点击某个网格图标的 **✎** 编辑
2. 点击 **选择文件** 上传一张本地图片（如 PNG、JPG）
3. 点击 **保存**

   - ✓ 图标应**立即替换**为用户上传的图片
   - ✓ 不应再尝试 Clearbit/HTML 解析

4. 关闭标签页重新打开
   - ✓ 用户上传的图标应保留

---

## 控制台日志检查清单

| 日志                                       | 含义                       | 预期                          |
| ------------------------------------------ | -------------------------- | ----------------------------- |
| `✓ 无 404 错误`                            | favicon 相关的网络请求失败 | ✅ 不应出现                   |
| `console.warn "Icon cache read failed"`    | 缓存读取出错               | ⚠️ 可以偶发（非关键）         |
| `console.warn "Clearbit attempt failed"`   | Clearbit 超时/网络问题     | ⚠️ 可以（会尝试 HTML 解析）   |
| `console.warn "HTML parse attempt failed"` | HTML 解析失败              | ⚠️ 可以（保留字母）           |
| `✓ 无大量重复的网络请求`                   | 缓存未被触发               | ✅ 应避免（刷新后应缓存命中） |

---

## 清空缓存方法

若需重新测试从零开始的加载体验：

```javascript
// 在扩展控制台运行
const req = indexedDB.deleteDatabase("favicon_cache_db");
req.onsuccess = () => console.log("✓ 缓存已清空");
req.onerror = () => console.log("✗ 清空失败", req.error);
```

然后刷新页面，观察是否恢复到"字母占位 → 真实图标"的替换流程。

---

## 自动化测试建议

若要验证整个流程的稳定性，建议测试：

1. **覆盖率测试** — 10+ 常见网站（GitHub、Gmail、ChatGPT 等）

   - 检查每个网站的图标是否成功加载
   - 检查字母占位是否一致

2. **缓存持久性测试** — 重启浏览器 / 禁用-启用扩展

   - 确认缓存在浏览器进程间保留
   - 确认 TTL 过期后自动清理

3. **拖拽插入精确性测试** — 侧边栏拖入多个位置
   - 验证插入点计算正确
   - 验证拖拽视觉反馈（shift-left/shift-right）

---

## 常见问题排查

### Q: 图标加载很慢 (5+ 秒)

**A**: 可能原因：

- Clearbit 网络延迟（正常）
- HTML 解析需要完整页面加载（预期行为）
- 尝试方案：关闭所有 VPN，检查网速

### Q: 某些网站始终显示字母占位

**A**: 可能原因：

- Clearbit 不支持该网站（小众网站正常）
- HTML 解析失败（CORS、页面结构变化）
- 尝试方案：在编辑对话手动输入图标 URL 或上传图片

### Q: 控制台有大量 404

**A**: **应该修复** — 说明仍有旧逻辑在尝试已弃用的来源

- 检查代码是否完全移除了 `DuckDuckGo`、`/favicon.ico` 等旧方案
- 搜索 `favicon()` 和 `faviconFallback()` 调用点，应已删除

### Q: 图标显示为空白 / undefined

**A**: **严重问题** — 说明字母占位逻辑未触发

- 检查 `showLetterIcon()` 是否在所有加载路径中都被调用
- 检查 `getTwoChars()` 是否返回有效值
- 在控制台运行：`console.log(getTwoChars("ChatGPT"))` 验证

---

## 提交验收条件

✅ 所有 6 个测试场景都通过
✅ 控制台无任何 favicon 相关 404 错误
✅ 网格、侧边栏、编辑对话的图标显示**完全一致**
✅ 缓存命中时，刷新后图标瞬速加载
✅ 拖拽插入准确无误，视觉反馈正确
