# Microsoft Edge Add-ons Store Submission Guide

To publish "Starty" to the Edge Add-ons Store, follow these steps.

## 1. Preparation

Before zipping your extension, ensure you have created the icon files referenced in `manifest.json`:

- Create a folder named `icons` in the root directory.
- Add your logo files:
  - `icons/icon16.png` (16x16 px)
  - `icons/icon48.png` (48x48 px)
  - `icons/icon128.png` (128x128 px)

## 2. Privacy Policy

Edge requires a publicly accessible URL for your privacy policy.

1. **Option A (GitHub Pages):** Push this code to a GitHub repository, enable GitHub Pages, and use the URL for `privacy.html`.
2. **Option B (Gist):** Copy the content of `PRIVACY.md` to a public GitHub Gist and use that URL.
3. **Option C (Website):** Host `privacy.html` on your own website.

**Privacy Policy URL Field:** Enter the URL you created above.

## 3. Store Listing Fields

### Description

> Starty is a clean, modern New Tab page replacement that helps you organize your bookmarks efficiently.
>
> **Key Features:**
>
> - **Visual Grid:** View your pinned bookmarks as a customizable grid.
> - **Smart Sidebar:** Access your full bookmark tree with a convenient sidebar.
> - **Icon Management:** Automatically fetches high-quality icons from multiple sources (DuckDuckGo, Clearbit, or website HTML).
> - **Customization:** Upload custom icons, change background colors, and set your preferred wallpaper.
> - **AI Organization:** (Optional) Use AI to automatically categorize your messy bookmarks.
>
> **Privacy First:**
> Starty operates locally on your device. Your bookmarks are never sent to our servers. External requests are made only to fetch icons or when you explicitly use the AI features.

### Justification for Permissions

You will be asked to justify why you need specific permissions. Copy and paste these:

**`bookmarks`**

> "The extension's core functionality is to display the user's bookmarks in a visual grid and sidebar on the New Tab page. It needs read access to the bookmark tree to render this interface."

**`storage`**

> "Used to save user preferences locally, such as the list of pinned sites, custom icon URLs, background colors, and the user's OpenAI API key."

**`host_permissions` (`<all_urls>`)**

> "Required to fetch high-resolution favicons directly from bookmarked websites. Standard favicon services often miss high-quality 'apple-touch-icons' or specific meta tags. The extension performs a background fetch of the bookmarked URL's HTML to parse these icon links. This occurs only when a user adds a site or loads the grid, and is strictly for icon retrieval."

## 4. Notes for Reviewers

If there is a "Notes for Reviewers" field, you can add:

> "This extension replaces the New Tab page. It uses a background script to fetch favicons from websites to avoid CORS issues in the main page. The AI feature is optional and requires the user to input their own API key."
