# Grid Start — Smart Bookmarks (MV3)

一个简洁的浏览器新标签页扩展：

- 读取你的浏览器收藏夹并以 2D 网格展示
- 支持按文件夹展开查看
- 自动获取站点图标（优先使用浏览器缓存，失败时用首字符代替）
- 可选 AI 分类整理（需本地"会员"开关或填入 OpenAI API Key）

> 设计风格参考 Infinity，但不包含网站推荐。

## 快速开始（本地开发）

1. 克隆或复制本项目到本地（你已在 VS Code 中）：

2. 在 Chrome 打开：chrome://extensions

- 打开右上角“开发者模式”
- 点击“加载已解压的扩展程序”，选择本项目文件夹

3. 新开一个标签页即可看到新主页。

## AI 整理

- 打开“设置”（右上角 chip），在“AI 提供商”中选择 OpenAI，并填入 API Key（可选）。
- 未填 Key 时，内置启发式分组（按域名/常见网站），可先体验效果。
- 会员开关为本地演示：新标签页中点击“登录/会员”，切换会员状态后可使用 AI 整理按钮。

## 文件结构

- `manifest.json` — MV3 清单，新标签页覆盖
- `index.html` / `styles.css` / `newtab.js` — 新标签页 UI 与逻辑
- `ai.js` — AI 分类封装，支持 OpenAI / 本地启发式
- `auth.js` — 简单本地登录/会员演示（chrome.storage）
- `options.html` / `options.js` — 设置页（API Key、壁纸、会员）
- `background.js` — 预留的后台 Service Worker

## 隐私与权限

- 权限仅使用 `bookmarks` 与 `storage`，读取本地收藏夹与保存设置。
- 所有数据默认保存在本地，调用 AI 时会将书签的“标题+URL”发送至你配置的提供商。

## 自定义

- 壁纸：在“设置”中填入图片 URL。
- 网格列数：在“设置”中调整（4–12），即时作用于新标签页。
- 搜索引擎：新标签页搜索栏上方可在 Google/Bing/百度/DDG 之间一键切换。
- 视觉：图标为按钮式，无外框；如需不同尺寸/圆角可改 `styles.css` 中 `.tile-icon`。

## 计划扩展（可选）

- 拖拽排序与自定义分组
- 离线 embedding + 本地分类
- 真正的登录/订阅（如接入 Supabase/Stripe）

---

如果你希望我继续：

- 接入真实会员/支付
- 增加拖拽与快捷键
- 做一套更贴近截图的主题
  ,请告诉我你的偏好。
