# Privacy Policy for Starty

**Last Updated:** December 4, 2025

## Introduction

Starty ("we", "our", or "us") is committed to protecting your privacy. This Privacy Policy explains how our browser extension collects, uses, and discloses your information.

## Data Collection and Usage

### 1. Bookmarks

**Permission:** `bookmarks`
**Usage:** Starty requests access to your browser's bookmarks solely to display them in the extension's interface (Sidebar and Grid).
**Storage:** We do not store your bookmarks on our servers. They remain locally on your device. We do not modify your browser bookmarks.

### 2. Local Storage

**Permission:** `storage`
**Usage:** We use your browser's local storage (`chrome.storage`) to save your preferences, such as:

- Pinned sites configuration
- Custom icons and background colors
- Wallpaper settings
- OpenAI API Key (if provided)
  **Storage:** This data is stored locally on your device and is not transmitted to us.

### 3. Website Data

**Permission:** `host_permissions` (`<all_urls>`)
**Usage:** Starty requires access to fetch favicons (website icons) directly from the websites you have bookmarked.
**Details:** When you add a site or load the grid, the extension may perform a background request to the website's URL to parse its HTML and find the highest quality icon. This happens locally on your browser. We do not track your browsing history.

## Third-Party Services

Starty interacts with the following third-party services to provide its functionality. Your use of these services is subject to their respective privacy policies.

### 1. Icon Services

To display icons for your bookmarks when a local one cannot be found, Starty may send the domain name of your bookmark to the following services:

- **DuckDuckGo:** `https://icons.duckduckgo.com`
- **Clearbit:** `https://logo.clearbit.com`

**Data Shared:** Domain name of the bookmark (e.g., "google.com"). Your IP address is visible to these services as part of the standard web request.

### 2. OpenAI (Optional)

**Feature:** AI Sort / Organize
**Usage:** If you choose to use the AI organization feature and provide your own API Key, Starty will send the titles and URLs of your bookmarks to OpenAI's API.
**Data Shared:** Bookmark titles and URLs.
**Privacy:** Please refer to [OpenAI's Privacy Policy](https://openai.com/privacy) for how they handle API data.

## Data Security

All sensitive data, such as your OpenAI API Key, is stored locally in your browser. We do not have access to this data.

## Changes to This Policy

We may update our Privacy Policy from time to time. We will notify you of any changes by posting the new Privacy Policy on this page.

## Contact Us

If you have any questions about this Privacy Policy, please contact us via the support section on the Microsoft Edge Add-ons Store.
